% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.r
\name{network}
\alias{network}
\alias{networkDynamic}
\alias{diffnet_to_network}
\alias{diffnet_to_networkDynamic}
\alias{networkDynamic_to_diffnet}
\alias{network_to_diffnet}
\title{Coercion between \code{diffnet}, \code{network} and \code{networkDynamic}}
\usage{
diffnet_to_network(graph, slices = 1:nslices(graph), ...)

diffnet_to_networkDynamic(graph, slices = 1:nslices(graph),
  diffnet2net.args = list(), netdyn.args = list())

networkDynamic_to_diffnet(graph, toavar)

network_to_diffnet(graph = NULL, graph.list = NULL, toavar, t0 = NULL,
  t1 = NULL)
}
\arguments{
\item{graph}{An object of class \code{\link{diffnet}}}

\item{slices}{An integer vector indicating the slices to subset}

\item{...}{Further arguments passed to \code{\link[networkDynamic:networkDynamic]{networkDynamic}}}

\item{diffnet2net.args}{List of arguments passed to \code{diffnet_to_network}.}

\item{netdyn.args}{List of arguments passed to \code{\link[networkDynamic:networkDynamic]{networkDynamic}}}

\item{toavar}{Character scalar. Name of the vertex attribute that holds the times of adoption.}

\item{graph.list}{A list of \code{network} objects.}

\item{t0}{Integer scalar. Passed to \code{\link[=diffnet-class]{new_diffnet}}.}

\item{t1}{Integer scalar. Passed to \code{\link[=diffnet-class]{new_diffnet}}.}
}
\value{
\code{diffnet_to_network} returns a list of length \code{length(slices)} in which
each element is a \code{\link[network:network]{network}} object corresponding a slice of the
\code{graph} (\code{diffnet} object). The attributes list will include \code{toa} (time of
adoption).

An object of class \code{networkDynamic}.
}
\description{
Coercion between \code{diffnet}, \code{network} and \code{networkDynamic}
}
\details{
\code{diffnet_to_networkDynamic} calls \code{diffnet_to_network} and
uses the output to call \code{networkDynamic}, passing the resulting list of
\code{network} objects as \code{network.list} (see \code{\link[networkDynamic:networkDynamic]{networkDynamic}}).

By default, \code{diffnet_to_networkDynamic} passes \code{net.obs.period} as
\preformatted{
  net.obs.period = list(
    observations = list(range(graph$meta$pers)),
    mode="discrete",
    time.increment = 1,
    time.unit = "step"
  )
}

By default, \code{networkDynamic_to_diffnet} uses the first slice as reference for
vertex attributes and times of adoption.

By default, \code{network_to_diffnet} uses the first element of \code{graph}
(a list) as reference for vertex attributes and times of adoption.
}
\section{Caveats}{

Since \code{diffnet} does not support edges attributes, these will be lost when
converting from \code{network}-type objects. The same applies to \code{network}
attributes.
}

\examples{
# Cohersing a diffnet to a list of networks ---------------------------------
set.seed(1)
ans <- diffnet_to_network(rdiffnet(20, 2))
ans

# and back
network_to_diffnet(graph.list = ans, toavar="toa")

# If it was static, we can use -graph- instead
network_to_diffnet(ans[[1]], toavar="toa")

# A random diffusion network ------------------------------------------------
set.seed(87)
dn  <- rdiffnet(50, 4)
ans <- diffnet_to_networkDynamic(dn)

# and back
networkDynamic_to_diffnet(ans, toavar = "toa")

}
\seealso{
Other Foreign: \code{\link{igraph}},
  \code{\link{read_pajek}}, \code{\link{read_ucinet_head}}
}
