% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.r
\name{diffreg}
\alias{diffreg}
\title{Diffusion regression model}
\usage{
diffreg(model, type = c("logit", "probit"))
}
\arguments{
\item{model}{An object of class formula where the right-hand-side is an object of
class \code{\link[=diffnet]{diffnet}}}

\item{type}{Character scalar. Either \code{"probit"} or \code{"logit"}.}
}
\value{
An object of class \code{\link[stats:glm]{glm}}.
}
\description{
A wrapper of \code{glm}, this function estimates a lagged regression model of
adoption as a function of exposure and other controls as especified by the
user.
}
\details{
The model must be in the following form:

\preformatted{
<diffnet object> ~ exposure + covariate1 + covariate2 + ...
}

Where \code{exposure} can be especified either as a simple term, or as a
call to the exposure function, e.g. to compute exposure with a lag of
length 2, the formula could be:

\preformatted{
<diffnet object> ~ exposure(lags = 2) + covariate1 + covariate2 + ...
}

When no argument is passed to \code{exposure}, the function sets a lag
of length 1 by default (see the \emph{Lagged regression} section).

This is a wrapper of \code{\link[stats:glm]{glm}}. The function does the
following steps:
\enumerate{
 \item Compute exposure by calling \code{exposure} on the LHS.
 \item Modify the formula so that the model is on adoption as a function of
 exposure and whatever covariates the user specifies.
 \item Selects either \code{"probit"} or \code{"logit"} and prepares the call
 to \code{glm}. This includes passing the following line:
 \preformatted{
 subset = ifelse(is.na(toa), TRUE, toa >= per)
 }
 This results in including observations that either did not adopted or up to
 the time of adoption.
 \item Estimates the model.
}

The data passed to \code{glm} is obtained by using \code{\link{as.data.frame.diffnet}}.
}
\section{Lagged regression}{


The model estimated is a lagged regression model that has two main assumptions:
\enumerate{
\item The network is exogenous to the behavior (no selection effect)
\item The influence effect (diffusion) happens in a lagged fasion, hence,
exposure is computed lagged.
}

If either of these two assumptions is not met, then the model becomes endogenous,
ans so inference becomes invalid.

In the case of the first assumption, the user can overcome the non-exogeneity
problem by providing an alternative network. This can be done by especifying
\code{alt.graph} in the \code{exposure} function so that the network becomes
exogenous to the adoption.
}

\examples{
data("medInnovationsDiffNet")

# Default model
ans <- diffreg(
  medInnovationsDiffNet ~ exposure + factor(city) + proage + per)
summary(ans)
}
