% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dong2013.R
\docType{data}
\name{Dong2013}
\alias{Dong2013}
\title{Network meta-analysis for chronic obstructive pulmonary disease}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{id}}\tab study ID \cr
\bold{\emph{treatment}}\tab treatment \cr
\bold{\emph{death}}\tab mortality \cr
\bold{\emph{randomized}}\tab number of individuals in treatment arm
}
}
\source{
Dong Y-H, Lin H-H, Shau W-Y, Wu Y-C, Chang C-H, Lai M-S (2013):
Comparative safety of inhaled medications in patients with chronic
obstructive pulmonary disease: systematic review and mixed
treatment comparison meta-analysis of randomised controlled trials.
\emph{Thorax},
\bold{68}, 48--56
}
\description{
Network meta-analysis comparing inhaled medications in patients
with chronic obstructive pulmonary disease.
}
\note{
The dataset Dong2013 is identical to dataset
\code{\link[metadat]{dat.dong2013}} in R package \bold{metadat}.
}
\examples{
head(dat.dong2013)

\donttest{
# Transform data from long arm-based format to contrast-based
# format. Argument 'sm' has to be used for odds ratio as summary
# measure; by default the risk ratio is used in the metabin
# function called internally.
#
pw1 <- pairwise(treatment, death, randomized, studlab = id,
  data = dat.dong2013, sm = "OR")

# Conduct Mantel-Haenszel network meta-analysis
#
netmetabin(pw1, ref = "plac")
}
}
\seealso{
\code{\link[metadat]{dat.dong2013}},
  \code{\link[meta]{pairwise}}, \code{\link[meta]{metabin}},
  \code{\link{netmetabin}}
}
\keyword{datasets}
