% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Woods2010.R
\docType{data}
\name{Woods2010}
\alias{Woods2010}
\title{Count statistics of survival data}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{author}}\tab first author / study name \cr
\bold{\emph{treatment}}\tab treatment \cr
\bold{\emph{r}}\tab number of deaths in treatment arm \cr
\bold{\emph{N}}\tab number of patients in treatment arm
}
}
\source{
Woods BS, Hawkins N, Scott DA (2010):
Network meta-analysis on the log-hazard scale, combining count and
hazard ratio statistics accounting for multi-arm trials: A
tutorial.
\emph{BMC Medical Research Methodology},
\bold{10}, 54
}
\description{
Count mortality statistics in randomised controlled trials of
treatments for chronic obstructive pulmonary disease (Woods et
al. (2010), Table 1).
}
\note{
The dataset Woods2010 is identical to dataset
\code{\link[metadat]{dat.woods2010}} in R package \bold{metadat}.
}
\examples{
head(dat.woods2010)

\donttest{
# Transform data from long arm-based format to contrast-based
# format Argument 'sm' has to be used for odds ratio as summary
# measure; by default the risk ratio is used in metabin() which is
# called internally.
#
pw1 <- pairwise(treatment, event = r, n = N,
  studlab = author, data = dat.woods2010, sm = "OR")
pw1

# Conduct network meta-analysis
#
net1 <- netmeta(pw1)
net1

# Show forest plot
#
forest(net1, ref = "Placebo", drop = TRUE,
  leftlabs = "Contrast to Placebo")
}
}
\seealso{
\code{\link[metadat]{dat.woods2010}},
  \code{\link[meta]{pairwise}}, \code{\link[meta]{metabin}},
  \code{\link{netmeta}}
}
\keyword{datasets}
