% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approximate.ranks.R
\name{approx_rank_expected}
\alias{approx_rank_expected}
\title{Approximation of expected ranks}
\usage{
approx_rank_expected(P, method = "lpom")
}
\arguments{
\item{P}{A partial ranking as matrix object calculated with \link{neighborhood_inclusion}
or \link{positional_dominance}.}

\item{method}{String indicating which method to be used. see Details.}
}
\value{
A vector containing approximated expected ranks.
}
\description{
Implements a variety of functions to approximate expected ranks
for partial rankings.
}
\details{
The \emph{method} parameter can be set to
\describe{
\item{lpom}{local partial order model}
\item{glpom}{extension of the local partial order model.}
\item{loof1}{based on a connection with relative rank probabilities.}
\item{loof2}{extension of the previous method.}
}
Which of the above methods performs best depends on the structure and size of the partial
ranking. See \code{vignette("benchmarks",package="netrankr")} for more details.
}
\examples{
P <- matrix(c(0,0,1,1,1,0,0,0,1,0,0,0,0,0,1,rep(0,10)),5,5,byrow=TRUE)
#Exact result
exact_rank_prob(P)$expected.rank

approx_rank_expected(P,method = 'lpom')
approx_rank_expected(P,method = 'glpom')
}
\references{
Brüggemann R., Simon, U., and Mey,S, 2005. Estimation of averaged
ranks by extended local partial order models. \emph{MATCH Commun. Math.
Comput. Chem.}, 54:489-518.

Brüggemann, R. and Carlsen, L., 2011. An improved estimation of averaged ranks
of partial orders. \emph{MATCH Commun. Math. Comput. Chem.},
65(2):383-414.

De Loof, L., De Baets, B., and De Meyer, H., 2011. Approximation of Average
Ranks in Posets. \emph{MATCH Commun. Math. Comput. Chem.}, 66:219-229.
}
\seealso{
\link{approx_rank_relative}, \link{exact_rank_prob}, \link{mcmc_rank_prob}
}
\author{
David Schoch
}
