% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sankeyNetwork.R
\name{sankeyNetwork}
\alias{sankeyNetwork}
\title{Create a D3 JavaScript Sankey diagram}
\source{
D3.js was created by Michael Bostock. See \url{http://d3js.org/} and, more
specifically for Sankey diagrams \url{http://bost.ocks.org/mike/sankey/}.
}
\usage{
sankeyNetwork(Links, Nodes, Source, Target, Value, NodeID, height = NULL,
  width = NULL, colourScale = "d3.scale.category20()", fontsize = 7,
  nodeWidth = 15, nodePadding = 10)
}
\arguments{
\item{Links}{a data frame object with the links between the nodes. It should
have include the \code{Source} and \code{Target} for each link. An optional
\code{Value} variable can be included to specify how close the nodes are to
one another.}

\item{Nodes}{a data frame containing the node id and properties of the nodes.
If no ID is specified then the nodes must be in the same order as the
\code{Source} variable column in the \code{Links} data frame. Currently only
grouping variable is allowed.}

\item{Source}{character string naming the network source variable in the
\code{Links} data frame.}

\item{Target}{character string naming the network target variable in the
\code{Links} data frame.}

\item{Value}{character string naming the variable in the \code{Links} data
frame for how far away the nodes are from one another.}

\item{NodeID}{character string specifying the node IDs in the \code{Nodes}
data frame.}

\item{height}{numeric height for the network graph's frame area in pixels.}

\item{width}{numeric width for the network graph's frame area in pixels.}

\item{colourScale}{character string specifying the categorical colour
scale for the nodes. See
\url{https://github.com/mbostock/d3/wiki/Ordinal-Scales}.}

\item{fontsize}{numeric font size in pixels for the node text labels.}

\item{nodeWidth}{numeric width of each node.}

\item{nodePadding}{numeric essentially influences the width height.}
}
\description{
Create a D3 JavaScript Sankey diagram
}
\examples{
\dontrun{
# Recreate Bostock Sankey diagram: http://bost.ocks.org/mike/sankey/
# Load energy projection data
library(RCurl)
URL <- "https://raw.githubusercontent.com/christophergandrud/networkD3/master/JSONdata/energy.json"
Energy <- getURL(URL, ssl.verifypeer = FALSE)
# Convert to data frame
EngLinks <- JSONtoDF(jsonStr = Energy, array = "links")
EngNodes <- JSONtoDF(jsonStr = Energy, array = "nodes")

# Plot
sankeyNetwork(Links = EngLinks, Nodes = EngNodes, Source = "source",
             Target = "target", Value = "value", NodeID = "name",
}
}

