% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_networkLite.R
\name{as.networkLite}
\alias{as.networkLite}
\alias{as.networkLite.network}
\alias{as.networkLite.networkLite}
\title{Convert to \code{networkLite} Representation.}
\usage{
as.networkLite(x, ...)

\method{as.networkLite}{network}(x, ..., atomize = TRUE)

\method{as.networkLite}{networkLite}(x, ...)
}
\arguments{
\item{x}{A \code{network} or \code{networkLite} object.}

\item{...}{additional arguments}

\item{atomize}{Logical; should we call \code{\link{atomize}} on the
\code{networkLite} before returning it?}
}
\value{
A corresponding \code{networkLite} object.
}
\description{
Convert to \code{networkLite} Representation.
}
\details{
\code{as.networkLite.network} converts a \code{network} object
to a \code{networkLite} object. \code{as.networkLite.networkLite}
returns the \code{networkLite} object unchanged.

Currently the network attributes \code{hyper}, \code{multiple}, and
\code{loops} must be \code{FALSE} for \code{networkLite}s;
attempting to convert a \code{network} to a \code{networkLite} when
this is not the case will result in an error.

The \code{...} are passed to \code{\link{atomize}} and can be used
to set the \code{upcast} argument controlling attribute conversion.
}
\seealso{
\code{\link{to_network_networkLite}}
}
