% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networktree.R
\name{networktree}
\alias{networktree}
\alias{networktree.default}
\alias{networktree.formula}
\title{networktree: Partitioning of network models}
\usage{
networktree(...)

\method{networktree}{default}(
  nodevars,
  splitvars,
  method = c("mob", "ctree"),
  model = "correlation",
  transform = c("cor", "pcor", "glasso"),
  na.action = na.omit,
  weights = NULL,
  ...
)

\method{networktree}{formula}(
  formula,
  data,
  transform = c("cor", "pcor", "glasso"),
  method = c("mob", "ctree"),
  na.action = na.omit,
  model = "correlation",
  ...
)
}
\arguments{
\item{...}{additional arguments passed to \code{\link[partykit]{mob_control}} (mob) 
or \code{\link[partykit]{ctree_control}} (ctree)}

\item{nodevars}{the variables with which to compute the network. Can be vector, matrix, or dataframe}

\item{splitvars}{the variables with which to test split the network. Can be vector, matrix, or dataframe}

\item{method}{"mob" or "ctree"}

\item{model}{can be any combination of c("correlation", "mean", "variance")
splits are determined based on the specified characteristics}

\item{transform}{should stored correlation matrices be transformed to partial correlations
or a graphical lasso for plotting? Can be set to "cor" (default), "pcor", or "glasso"}

\item{na.action}{a function which indicates what should happen when the data
contain missing values (\code{NA}s).}

\item{weights}{weights}

\item{formula}{A symbolic description of the model to be fit. This
should either be of type \code{y1 + y2 + y3 ~ x1 + x2} with node
vectors \code{y1}, \code{y2}, and \code{y3} or \code{y ~ x1 + x2}
with a matrix response {y}. \code{x1} and \code{x2} are used as
partitioning variables.}

\item{data}{a data frame containing the variables in the model}
}
\description{
Computes a tree model with networks at the end of branches. Can use
model-based recursive partitioning or conditional inference.

Wraps the mob() and ctree() functions from the partykit package.
}
\examples{

set.seed(1)
d <- data.frame(trend = 1:200, foo = runif(200, -1, 1))
d <- cbind(d, rbind(
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0.5, 0.5, 0.5, 1, 0.5, 0.5, 0.5, 1), ncol = 3)),
  mvtnorm::rmvnorm(100, mean = c(0, 0, 0),
          sigma = matrix(c(1, 0, 0.5, 0, 1, 0.5, 0.5, 0.5, 1), ncol = 3))
))
colnames(d)[3:5] <- paste0("y", 1:3)

## Now use the function
tree1 <- networktree(nodevars=d[,3:5], splitvars=d[,1:2])

## Formula interface
tree2 <- networktree(y1 + y2 + y3 ~ trend + foo, data=d)

## plot 
plot(tree2)
plot(tree2, terminal_panel = "box")
plot(tree2, terminal_panel = "matrix")

\donttest{
## Conditional version
tree3 <- networktree(nodevars=d[,3:5], splitvars=d[,1:2], 
                     method="ctree")

## Change control arguments
tree4 <- networktree(nodevars=d[,3:5], splitvars=d[,1:2],
                     alpha=0.01)
}
}
\references{
Jones, P.J., Mair, P., Simon, T., Zeileis, A. (2020). Network trees: A method for recursively partitioning covariance structures. Psychometrika. Advance online publication. https://doi.org/10.1007/s11336-020-09731-4
}
