% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{OutlierIndex-class}
\alias{OutlierIndex-class}
\alias{.OutlierIndex}
\title{Outliers}
\description{
An S4 class to store the result of outlier detection.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{A \code{\link{logical}} matrix.}

\item{\code{codes}}{A \code{\link{character}} vector to store the laboratory codes
(unique identifiers).}

\item{\code{samples}}{A \code{\link{character}} vector to store the sample identifiers
(allows duplicates in case of repeated measurements).}

\item{\code{groups}}{A \code{\link{character}} vector to store the group names (if any).}

\item{\code{distances}}{A \code{\link{numeric}} matrix giving the squared Mahalanobis distance.}

\item{\code{limit}}{A \code{\link{numeric}} value giving the cut-off value used for outlier
detection (quantile of the Chi-squared distribution).}

\item{\code{robust}}{An \code{\link{logical}} scalar: were robust estimators used?}

\item{\code{dof}}{A (non-negative) \code{\link{numeric}} value giving the degrees of freedom.}
}}

\note{
These classes inherit from \code{\link{logical}}.
}
\section{Coerce}{

In the code snippets below, \code{x} is a \code{OutlierIndex} object.
\describe{
\item{\code{as.data.frame(x)}}{Coerces to a \code{\link{data.frame}}.}
}
}

\seealso{
Other classes: 
\code{\link{CompositionMatrix-class}},
\code{\link{LogRatio-class}},
\code{\link{LogicalMatrix-class}},
\code{\link{NumericMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{classes}
\keyword{internal}
