% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/aggregate.R
\docType{methods}
\name{aggregate}
\alias{aggregate}
\alias{aggregate,CompositionMatrix-method}
\title{Compute Summary Statistics of Data Subsets}
\usage{
\S4method{aggregate}{CompositionMatrix}(x, by, FUN, ..., simplify = TRUE, drop = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{by}{A \code{vector} or a list of grouping elements, each as long as the
variables in \code{x}. The elements are coerced to factors before use
(in the sense that \code{\link[=interaction]{interaction(by)}} defines the grouping).}

\item{FUN}{A \code{\link{function}} to compute the summary statistics.}

\item{...}{Further arguments to be passed to \code{FUN}.}

\item{simplify}{A \code{\link{logical}} scalar: should the results be simplified to a
matrix if possible?}

\item{drop}{A \code{\link{logical}} scalar indicating whether to drop unused
combinations of grouping values.}
}
\value{
A \code{\link{matrix}}.
}
\description{
Splits the data into subsets, computes summary statistics for each, and
returns the result.
}
\examples{
## Data from Aitchison 1986
data("slides")

## Coerce to a compositional matrix
coda <- as_composition(slides)

## Compositional mean by slide
aggregate(coda, by = slides$slide, FUN = mean)

## Metric variance by slide
aggregate(coda, by = slides$slide, FUN = variance_total)
}
\seealso{
Other statistics: 
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
