% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vaa.R
\name{download_vaa}
\alias{download_vaa}
\title{Download nhdplusVAA data from HydroShare}
\usage{
download_vaa(
  path = get_vaa_path(updated_network),
  force = FALSE,
  updated_network = FALSE
)
}
\arguments{
\item{path}{character path where the file should be saved. Default is a
persistent system data as retrieved by \link{nhdplusTools_data_dir}.
Also see: \link{get_vaa_path}}

\item{force}{logical. Force data re-download. Default = FALSE}

\item{updated_network}{logical default FALSE. If TRUE, updated network attributes
from E2NHD and National Water Model retrieved from
\href{https://www.sciencebase.gov/catalog/item/60c92503d34e86b9389df1c9}{here.}}
}
\value{
character path to cached data
}
\description{
downloads and caches nhdplusVAA data on your computer
}
\details{
The VAA data is a aggregate table of information from the NHDPlusV2
elevslope.dbf(s), PlusFlowlineVAA.dbf(s); and NHDFlowlines. All data
originates from the EPA NHDPlus Homepage
\href{https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data}{here}.
To see the location of cached data on your machine use
\code{\link{get_vaa_path}}.
To view aggregate data and documentation, see
\href{https://www.hydroshare.org/resource/6092c8a62fac45be97a09bfd0b0bf726/}{here}
}
