% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_retrieval.R
\name{GetHeatmapCoords}
\alias{GetHeatmapCoords}
\title{Get the heatmap coordinates for certain events in the database}
\usage{
GetHeatmapCoords(team_id, gids, events_list)
}
\arguments{
\item{team_id}{Int, id of the team to transfrom for}

\item{gids}{Int, list of game ids to check for events}

\item{events_list}{Character, string of events to select from the database
Note that events must be quoted in single quotes inside the string}
}
\value{
List, containing all x, y pairs for events and additional metadata
}
\description{
This function will take in a team_id and a list of game_ids, and a list of
events to looks for, and resturn a list of x, y coordinates, transformed to
be attacking zone on the left of the rink, and defending zone on the right of the rink.
Some anomalies due to how the NHL tracks positions
}
\examples{
SetDbPath(example = TRUE)
GetHeatmapCoords(10, 2019020001, "'Shot', 'Goal'")

}
