% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppp.R
\name{ppp}
\alias{ppp}
\title{Simulate a homogeneous Poisson Point Process in (t_min, t_max]}
\usage{
ppp(rate, t_min, t_max, atmost1 = FALSE, tol = 10^-6)
}
\arguments{
\item{rate}{(scalar, double) constant instantaneous rate}

\item{t_min}{(scalar, double) the lower bound of the time interval}

\item{t_max}{(scalar, double) the upper bound of the time interval}

\item{atmost1}{boolean, draw at most 1 event time}

\item{tol}{the probability that we will have more than
the drawn events in (t_min, t_max]}
}
\value{
a vector of event times t
if no events realize, it will have 0 length
}
\description{
Simulate a homogeneous Poisson Point Process in (t_min, t_max]
}
\examples{
x <- ppp(rate = 1, t_min = 0, t_max = 10, tol = 10^-6)
}
