% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSAVI.R
\name{MSAVI}
\alias{MSAVI}
\title{MSAVI - Modified Soil Adjusted Vegetation Index}
\usage{
MSAVI(R, NIR)
}
\arguments{
\item{R}{A raster layer object with the reflectance values for the Red band.}

\item{NIR}{A raster layer object with the reflectance values for the Near Infrared band.}
}
\value{
MSAVI - Modified Soil Adjusted Vegetation Index.
}
\description{
MSAVI minimizes the effect of bare soil on the Soil Adjusted Vegetation Index.
}
\examples{
library(raster)
path_files <- system.file("extdata/", package="nightmares")
bands <- stack(list.files(path_files,".tif", full.names=TRUE))
x <- ref_oli(bands, sun.elev= 67.97)
MSAVI(x[[4]], x[[5]])

}
\references{
\url{https://www.usgs.gov/core-science-systems/nli/landsat/landsat-surface-reflectance-derived-spectral-indices}.
\url{https://www.geo.university/pages/spectral-indices-with-multispectral-satellite-data}.
}
