% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solrad.R
\name{solrad}
\alias{solrad}
\title{Solar radiation from air temperature differences}
\usage{
solrad(kRs, tmax, tmin, lat, doy)
}
\arguments{
\item{kRs}{Adjustment coefficient. Interior locations = 0.16, ..., Coastal locations = 0.19.}

\item{tmax}{Maximum air temperature in Celsius degrees.}

\item{tmin}{Minimum air temperature in Celsius degrees.}

\item{lat}{Latitude in decimal degrees.}

\item{doy}{Day of the year.}
}
\value{
Solar radiation in MJ/sq.m/day.
}
\description{
This function is used to estimate the Solar Radiation in MJ/sq.m/day from air temperature differences by using the Hargreaves radiation formula.
Please, see the equation 50 from the FAO Irrigation and drainage paper 56.
}
\examples{
solrad(kRs= 0.19, tmax= 25, tmin= 15, lat= 43.5, doy= 150)

}
\references{
Allen et al., 1998. Crop Evapotranspiration. Guidelines for computing crop water requirements. FAO Irrigation and drainage paper 56.
\url{http://www.fao.org/3/X0490E/x0490e00.htm}.
}
