% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk.R
\name{nll}
\alias{nll}
\title{Risk for Cross-Entropy Loss}
\usage{
nll(prediction, outcome)
}
\arguments{
\item{prediction}{A \code{numeric} vector of predicted probabilities.}

\item{outcome}{A \code{numeric} vector of binary outcomes actually observed.}
}
\description{
Compute the empirical risk under cross-entropy loss for binary predictions.
}
\examples{
n_obs <- 100
x <- rnorm(n_obs)
y <- rbinom(n_obs, 1, plogis(x^2))
test_x <- rnorm(n_obs)
test_y <- rbinom(n_obs, 1, plogis(test_x^2))
mod <- glm(y ~ x, family = "binomial")
pred <- predict(mod, newx = as.data.frame(test_x), type = "response")
error <- nll(prediction = unname(pred), outcome = test_y)
}
