% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNP_distributions.R
\name{StickBreakingFunction}
\alias{StickBreakingFunction}
\alias{stick_breaking}
\alias{stickbreaking}
\title{The Stick Breaking Function}
\usage{
stick_breaking(z, log = 0)
}
\arguments{
\item{z}{vector argument.}

\item{log}{logical; if \code{TRUE}, weights are returned on the log scale.}
}
\description{
EXPERIMENTAL Computes probabilities based on stick breaking construction.
}
\details{
The stick breaking function produces a vector of probabilities that add up to one,
based on a series of individual probabilities in \code{z}, which define the breaking
points relative to the remaining stick length. The first element of \code{z} determines
the first probability based on breaking a proportion \code{z[1]} from a stick of length one.
The second element of \code{z} determines the second probability based on breaking a
proportion \code{z[2]} from the remaining stick (of length \code{1-z[1]}), and so forth.
Each element of \code{z} should be in 
\eqn{(0,1)}.
The returned vector has length equal to the length of \code{z} plus 1. 
If \code{z[k]} is equal to 1 for any \code{k}, then the returned vector has length smaller than \code{z}. 
If one of the components is smaller than 0 or greater than 1, \code{NaN}s are returned.
}
\examples{
z <- rbeta(5, 1, 1)
stick_breaking(z)

\dontrun{
cstick_breaking <- compileNimble(stick_breaking)
cstick_breaking(z)
}
}
\author{
Claudia Wehrhahn
}
\references{
Sethuraman, J. (1994). A constructive definition of Dirichlet priors.
 \emph{Statistica Sinica}, 639-650.
}

