% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.spdppc.R
\name{plot.spdppc}
\alias{plot.spdppc}
\title{Plot SPD-based Posterior Predictive Check}
\usage{
\method{plot}{spdppc}(
  x,
  type = "envelope",
  nsample = NULL,
  interval = 0.9,
  obs.lwd = 1.5,
  obs.col = "black",
  sim.col = "lightgrey",
  alpha = 1,
  envelope.col = "lightgrey",
  positive.col = "red",
  negative.col = "blue",
  calendar = "BP",
  ...
)
}
\arguments{
\item{x}{An \code{spdppc} class object.}

\item{type}{Either a 'spaghetti' plot or a quantile based envelope plot. Default is 'envelope'.}

\item{nsample}{Number of samples to be displayed in the 'spaghetti' plot. Default is the total number of simulations supplied in the 'spdppc' class object, ignored when \code{type} is set to 'envelope'.}

\item{interval}{Quantile interval used for the envelope plot. Ignored when \code{type} is set to 'spaghetti'. Default is 0.90.}

\item{obs.lwd}{Line width of the observed SPD. Default is 1.5.}

\item{obs.col}{Line colour of the observed SPD. Default is 'black'.}

\item{sim.col}{Line colour of simulated SPDs. Default is 'lightgrey', ignored when \code{type} is set to 'envelope'.}

\item{alpha}{Transparency value for each line in the spaghetti plot. Default is 1, ignored when \code{type} is set to 'envelope'.}

\item{envelope.col}{Fill colour of the simulation envelope. Default is 'lightgrey', ignored when \code{type} is set to 'envelope.'spaghetti'.}

\item{positive.col}{Fill colour for the area with positive deviation from the simulation envelope.  Default is 'red', ignored when \code{type} is set to 'spaghetti'.}

\item{negative.col}{Fill colour for the area with positive deviation from the simulation envelope.  Default is 'blue', ignored when \code{type} is set to 'spaghetti'.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{...}{Additional arguments affecting the plot}
}
\value{
None.
}
\description{
Plots \code{spdppc} class object for SPD-based Posterior Predictive Check.
}
