% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topTable.R
\docType{methods}
\name{topTable-methods}
\alias{topTable-methods}
\alias{topTable}
\alias{topTable,nlcv-method}
\title{Methods for topTable}
\usage{
\S4method{topTable}{nlcv}(fit, n = 5, method = "percentage")
}
\arguments{
\item{fit}{object resulting from a classification or regression procedure}

\item{n}{number of features that one wants to extract from a table that
ranks all features according to their importance in the classification or
regression model}

\item{method}{method used to rank the features; one of \code{percentage}
(percentage of runs the feature is selected in the top n), \code{meanrank}
(mean rank of the feature across runs) or \code{medianrank} (median rank of
the feature across runs); \code{percentage} is the default method}
}
\value{
a data frame of one column (\code{percentage}) with percentages
reflecting the frequency of selection of a feature in the top n across all
runs; the features are sorted on decreasing frequency.
}
\description{
Methods for topTable. topTable extracts the top n most important features
for a given classification or regression procedure.
}
\details{
The top n features are extracted across all runs of the nested loop
cross-validation. After ranking on their frequency of selection, the top n
are retained and returned.
}
\section{Methods}{
 \describe{

nlcv

\item{fit = "nlcv"}{nlcv objects are produced by \code{nlcv}} }
}

\examples{

  data(nlcvRF_SS)
  topTable(nlcvRF_SS, n = 7, method = "medianrank")
}
\author{
Willem Talloen and Tobias Verbeke
}
\keyword{manip}
\keyword{methods}
