### $Id: Dialyzer.R,v 1.1 2000/03/17 22:21:21 saikat Exp $
### Data on high flux hemodialyzers measured to assess ultrafiltration
### SAS System for Mixed Models (1996), p. 268
"Dialyzer" <-
  structure(list(
  Subject = structure(c(9, 9, 9, 9, 9, 9, 9, 3, 
    3, 3, 3, 3, 3, 3, 5, 5, 5, 5, 5, 5, 5, 10, 10, 10, 10, 10, 10, 
    10, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 
    8, 8, 2, 2, 2, 2, 2, 2, 2, 7, 7, 7, 7, 7, 7, 7, 1, 1, 1, 1, 1, 
    1, 1, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 
    16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 19, 19, 
    19, 19, 19, 19, 19, 15, 15, 15, 15, 15, 15, 15, 11, 11, 11, 11, 
    11, 11, 11, 18, 18, 18, 18, 18, 18, 18, 20, 20, 20, 20, 20, 20, 
    20, 12, 12, 12, 12, 12, 12, 12),
    .Label = c("10", "8", "2", "6", "3", "5", "9", "7", "1", "4",
      "17", "20", "11", "12", "16", "13", "14", "18", "15", "19"),
    class = c("ordered", "factor")),
QB = structure(c(1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
  1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2),
  .Label = c("200", "300"), class = "factor"),
pressure = c(0.24, 0.505, 0.995, 1.485, 
  2.02, 2.495, 2.97, 0.24, 0.54, 0.995, 1.475, 2, 2.5, 3.01, 0.245, 
  0.48, 1.01, 1.505, 2, 2.515, 2.97, 0.255, 0.495, 0.995, 1.48, 
  1.995, 2.49, 3.03, 0.255, 0.515, 1, 1.505, 2.02, 2.49, 3.01, 
  0.26, 0.5, 1.02, 1.49, 1.99, 2.48, 2.995, 0.305, 0.505, 0.98, 
  1.505, 2.005, 2.505, 2.99, 0.305, 0.505, 0.995, 1.5, 1.99, 2.48, 
  3, 0.25, 0.495, 1, 1.5, 1.965, 2.485, 2.98, 0.235, 0.505, 1.02, 
  1.475, 1.97, 2.48, 3, 0.255, 0.5, 0.98, 1.49, 2.015, 2.51, 2.98, 
  0.28, 0.505, 1, 1.49, 2, 2.505, 3.02, 0.355, 0.48, 1.025, 1.5, 
  1.99, 2.5, 3.005, 0.235, 0.48, 1.01, 1.49, 1.99, 2.48, 3.005, 
  0.26, 0.515, 0.97, 1.505, 1.99, 2.5, 2.995, 0.235, 0.485, 1.025, 
  1.515, 1.99, 2.51, 3.02, 0.285, 0.52, 1.005, 1.5, 1.985, 2.49, 
  2.995, 0.295, 0.515, 1.01, 1.48, 2, 2.48, 3.005, 0.29, 0.495, 
  1.015, 1.52, 2.02, 2.5, 2.975, 0.4, 0.47, 1.01, 1.515, 1.98, 
  2.51, 3),
rate = c(0.645, 20.115, 38.46, 44.985, 51.765, 46.575, 
  40.815, 3.72, 18.885, 34.695, 40.305, 44.475, 42.435, 44.655, 
  2.985, 17.7, 35.295, 41.955, 47.61, 44.73, 46.035, 3.93, 19.83, 
  40.425, 52.26, 49.395, 45.975, 41.91, 3.21, 17.7, 32.49, 42.33, 
  45.735, 47.85, 48.045, 3.66, 16.95, 36.09, 42.63, 46.47, 46.275, 
  43.98, 9.825, 21.63, 42.27, 50.28, 45.51, 44.25, 42.3, 9.48, 
  21.75, 37.23, 44.43, 42.165, 43.065, 36.615, 1.56, 16.65, 34.53, 
  43.815, 48.495, 47.52, 41.64, 1.23, 15.375, 32.835, 37.83, 40.59, 
  32.55, 34.305, 3.885, 19.155, 37.65, 47.895, 54.495, 53.175, 
  59.355, 5.715, 20.505, 39.405, 50.1, 55.155, 61.185, 50.715, 
  10.41, 19.32, 43.77, 51.225, 58.095, 54.09, 62.01, 3.6, 20.49, 
  41.88, 49.995, 57.675, 62.475, 62.145, 1.89, 18.51, 37.215, 52.35, 
  60.915, 62.985, 64.77, 1.17, 17.685, 39.705, 52.68, 61.8, 61.485, 
  61.425, 1.5, 15.405, 32.52, 42.435, 48.57, 53.685, 53.655, 6.42, 
  20.25, 43.05, 58.11, 61.995, 60.915, 63.6, 4.05, 16.59, 40.515, 
  52.845, 60.435, 64.83, 63.825, 10.935, 13.47, 35.355, 45.345, 
  49.44, 53.625, 56.43),
index = c(1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 4, 5, 6, 7, 1, 2, 3, 
  4, 5, 6, 7)),
.Names = c("Subject", "QB", "pressure", "rate", "index"),
row.names = as.character(1:140),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = rate ~ pressure | Subject,
labels = structure(list(x = "Transmembrane pressure",
  y = "Ultrafiltration rate"), .Names = c("x", "y")),
units = structure(list(x = "(dmHg)", y = "(ml/hr)"),
.Names = c("x", "y")),
outer = ~QB,
FUN = function (x) max(x, na.rm = TRUE),
order.groups = TRUE)
