
<!-- README.md is generated from README.Rmd. Please edit that file -->

# [**nloptr**](https://astamm.github.io/nloptr/) <img src='man/figures/logo.png' align="right" height="139" />

<!-- badges: start -->

[![R-CMD-check](https://github.com/astamm/nloptr/workflows/R-CMD-check/badge.svg)](https://github.com/astamm/nloptr/actions)
[![test-coverage](https://github.com/astamm/nloptr/workflows/test-coverage/badge.svg)](https://github.com/astamm/nloptr/actions)
[![Codecov test
coverage](https://codecov.io/gh/astamm/nloptr/branch/master/graph/badge.svg)](https://app.codecov.io/gh/astamm/nloptr?branch=master)
[![pkgdown](https://github.com/astamm/nloptr/workflows/pkgdown/badge.svg)](https://github.com/astamm/nloptr/actions)
[![CRAN
status](https://www.r-pkg.org/badges/version/nloptr)](https://CRAN.R-project.org/package=nloptr)
<!-- badges: end -->

[**nloptr**](https://astamm.github.io/nloptr/) is an R interface to
[NLopt](https://nlopt.readthedocs.io/en/latest/), a free/open-source
library for nonlinear optimization started by Steven G. Johnson,
providing a common interface for a number of different free optimization
routines available online as well as original implementations of various
other algorithms. It can be used to solve general nonlinear programming
problems with nonlinear constraints and lower and upper bounds for the
controls, such as

![\min\_{x \in \mathbb{R}^n} \quad f(x),](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;%5Cmin_%7Bx%20%5Cin%20%5Cmathbb%7BR%7D%5En%7D%20%5Cquad%20f%28x%29%2C "\min_{x \in \mathbb{R}^n} \quad f(x),")

s.t.
![g(x) \le 0](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;g%28x%29%20%5Cle%200 "g(x) \le 0"),
![h(x) = 0](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;h%28x%29%20%3D%200 "h(x) = 0")
and
![\ell \le x \le u](https://latex.codecogs.com/png.image?%5Cdpi%7B110%7D&space;%5Cbg_white&space;%5Cell%20%5Cle%20x%20%5Cle%20u "\ell \le x \le u").

The [NLopt](https://nlopt.readthedocs.io/en/latest/) library is
available under the GNU Lesser General Public License (LGPL), and the
copyrights are owned by a variety of authors. See the
[website](https://nlopt.readthedocs.io/en/latest/Citing_NLopt/) for
information on how to cite NLopt and the algorithms you use.

## Installation

### Windows

On Windows, either the latest version `2.7.1` of
[NLopt](https://nlopt.readthedocs.io/en/latest/) from
[rwinlib](https://github.com/rwinlib/nlopt) (windows-release) or the
`v2.7.1` build from the `rtools42` toolchain (windows2022-devel) is
used. So there is nothing else to be done.

### Linux and macOS

On Unix-like platforms, we use `pkg-config` to find a suitable system
build of [NLopt](https://nlopt.readthedocs.io/en/latest/) (i.e. with
version `>= 2.7.0`).

-   If it is found it is used.
-   Otherwise, [NLopt](https://nlopt.readthedocs.io/en/latest/) 2.7.1 is
    built from included sources using [CMake](https://cmake.org). In
    this case, a binary of [CMake](https://cmake.org) stored in
    environment variable `CMAKE_BIN` is searched on the `PATH` and,
    alternatively, on a macOS-specific location. If that variable cannot
    be set, install will abort suggesting ways of installing
    [CMake](https://cmake.org). The minimal version requirement on
    `cmake` is `>= 3.15.0`.

### Installing [CMake](https://cmake.org) (macOS and Linux only)

You can install [CMake](https://cmake.org) by following [CMake
installation instructions](https://cmake.org/install/). The important
thing is that you add the [CMake](https://cmake.org) binary to your
`PATH`:

-   On macOS, you can install [CMake](https://cmake.org) and then run
    it. In the menu bar, there is an item *How to Install For Command
    Line Use* which you can click on to have proper instructions on how
    to update your `PATH`. Note that the location of the
    [CMake](https://cmake.org) binary is always
    `/Applications/CMake.app/Contents/bin/cmake`. Hence,
    [**nloptr**](https://astamm.github.io/nloptr/) knows where to find
    it even if you do not update your `PATH`.
-   On Linux, it will be automatically added unless you specifically
    change the default installation directory before building
    [CMake](https://cmake.org).

Alternatively, you can set an environment variable `CMAKE_BIN` pointing
to a [CMake](https://cmake.org) binary of your liking on your computer
for [**nloptr**](https://astamm.github.io/nloptr/) to use.

### Installing [**nloptr**](https://astamm.github.io/nloptr/)

You can install [**nloptr**](https://astamm.github.io/nloptr/) from CRAN
using:

    install.packages("nloptr")

Alternatively, you can install the development version from GitHub:

    # install.packages("remotes")
    remotes::install_github("astamm/nloptr")

## Acknowledgments

I would like to express my sincere gratitude to [Dirk
Eddelbuettel](https://github.com/eddelbuettel), [Jeroen
Ooms](https://github.com/jeroen), [Tomas
Kalibera](https://github.com/kalibera), Uwe Ligges and [Jelmer
Ypma](https://github.com/jyypma) for their contributions and the very
instructive discussions about the pros and cons of various build
strategies in R packages.

## Reference

Steven G. Johnson, The NLopt nonlinear-optimization package,
<https://nlopt.readthedocs.io/en/latest/>
