% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_cov.R
\name{var_cov}
\alias{var_cov}
\title{Variance Covariance matrix of for g(n)ls and (n)lme models}
\usage{
var_cov(
  object,
  type = c("residual", "random", "all"),
  aug = FALSE,
  sparse = FALSE
)
}
\arguments{
\item{object}{object which inherits class \code{\link[stats]{lm}}, \code{\link[nlme]{gls}} or \code{\link[nlme]{lme}}}

\item{type}{\dQuote{residual} for the variance-covariance for the residuals, \dQuote{random}
for the variance-covariance of the random effects or \dQuote{all} for the sum of both.}

\item{aug}{whether to augment the matrix of the random effects to the dimensions of the data}

\item{sparse}{whether to return a sparse matrix (default is FALSE)}
}
\value{
It returns a \code{\link[base]{matrix}} or a sparse matrix \code{\link[Matrix]{Matrix}}.
}
\description{
Extracts the variance covariance matrix (residuals, random or all)
}
\details{
Variance Covariance matrix for (non)linear mixed models
}
\note{
See Chapter 5 of Pinheiro and Bates. This returns potentially a very large 
matrix of N x N, where N is the number of rows in the data.frame. 
The function \code{\link[nlme]{getVarCov}} only works well for  
\code{\link[nlme]{lme}} objects. \cr
The equivalence is more or less: \cr
getVarCov type = \dQuote{random.effects} equivalent to var_cov type = \dQuote{random}. \cr
getVarCov type = \dQuote{conditional} equivalent to var_cov type = \dQuote{residual}. \cr
getVarCov type = \dQuote{marginal} equivalent to var_cov type = \dQuote{all}. \cr
The difference is that getVarCov has an argument that specifies the individual 
for which the matrix is being retrieved and var_cov returns the full matrix only.
}
\examples{
\donttest{
require(graphics)
require(nlme)
data(ChickWeight)
## First a linear model
flm <- lm(weight ~ Time, data = ChickWeight)
vlm <- var_cov(flm)
## First model with no modeling of the Variance-Covariance
fit0 <- gls(weight ~ Time, data = ChickWeight)
v0 <- var_cov(fit0)
## Only modeling the diagonal (weights)
fit1 <- gls(weight ~ Time, data = ChickWeight, weights = varPower())
v1 <- var_cov(fit1)
## Only the correlation structure is defined and there are no groups
fit2 <- gls(weight ~ Time, data = ChickWeight, correlation = corAR1())
v2 <- var_cov(fit2)
## The correlation structure is defined and there are groups present
fit3 <- gls(weight ~ Time, data = ChickWeight, correlation = corCAR1(form = ~ Time | Chick))
v3 <- var_cov(fit3)
## There are both weights and correlations
fit4 <- gls(weight ~ Time, data = ChickWeight, 
            weights = varPower(),
            correlation = corCAR1(form = ~ Time | Chick))
v4 <- var_cov(fit4)
## Tip: you can visualize these matrices using
image(v4[,ncol(v4):1])
}
}
\seealso{
\code{\link[nlme]{getVarCov}}
}
