% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSagauss.R
\name{SSagauss}
\alias{SSagauss}
\alias{agauss}
\title{self start for an asymmetric Gaussian bell-shaped curve}
\usage{
agauss(x, eta, beta, delta, sigma1, sigma2)

SSagauss(x, eta, beta, delta, sigma1, sigma2)
}
\arguments{
\item{x}{input vector}

\item{eta}{maximum value of y}

\item{beta}{parameter controlling the lower values}

\item{delta}{break-point separating the first and second half-bell curve}

\item{sigma1}{scale for the first half}

\item{sigma2}{scale for the second half}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

agauss: vector of the same length as x using an asymmetric bell-shaped Gaussian curve
}
\description{
Self starter for a type of bell-shaped curve
}
\details{
This function is described in (doi:10.3390/rs12050827).
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:30
y <- agauss(x, 10, 2, 10, 2, 6) + rnorm(length(x), 0, 0.02)
dat <- data.frame(x = x, y = y)
fit <- minpack.lm::nlsLM(y ~ SSagauss(x, eta, beta, delta, sigma1, sigma2), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
