% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSexpfp.R
\name{SSexpfp}
\alias{SSexpfp}
\alias{expfp}
\title{self start for an exponential-plateau function}
\usage{
expfp(x, a, c, xs)

SSexpfp(x, a, c, xs)
}
\arguments{
\item{x}{input vector (x)}

\item{a}{represents the value at x = 0}

\item{c}{represents the exponential rate}

\item{xs}{represents the breakpoint at which the plateau starts}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

expfp: vector of the same length as x using the expfp function
}
\description{
Self starter for an exponential-plateau function
}
\details{
This is the exponential-plateua function, where \sQuote{xs} is the break-point

\deqn{(x < xs) * a * exp(c * x) + (x >= xs) * (a * exp(c * xs))}

For more details see: Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(12345)
x <- 1:30
y <- expfp(x, 10, 0.1, 15) + rnorm(30, 0, 1.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSexpfp(x, a, c, xs), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
