% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdesign_helper.R
\name{simdesign_GenAlg}
\alias{simdesign_GenAlg}
\title{Add a Genetic Algorithm simdesign to a nl object}
\usage{
simdesign_GenAlg(nl, popSize = 200, iters = 100, evalcrit = 1,
  elitism = NA, mutationChance = NA, nseeds = 1)
}
\arguments{
\item{nl}{nl object with a defined experiment}

\item{popSize}{population Size parameter for genetic algorithm}

\item{iters}{number of iterations for genetic algorithm function}

\item{evalcrit}{position of evaluation criterion within defined NetLogo metrics of nl experiment}

\item{elitism}{elitism rate of genetic algorithm function}

\item{mutationChance}{mutation rate of genetic algorithm function}

\item{nseeds}{number of seeds for this simulation design}
}
\value{
simdesign S4 class object
}
\description{
Add a Genetic Algorithm simdesign to a nl object
}
\details{
This function creates a simdesign S4 class which can be added to a nl object.

Variables in the experiment variable list need to provide a numeric distribution with min and max (e.g. list(min=1, max=4)).

The GenAlg simdesign generates a Genetic Algorithm experiment within the defined min and max parameter boundaries
that are defined in the variables field of the experiment object within the nl object.
The evalcrit reporter defines the evaluation criterion for the simulated annealing procedure.
The reporter is defined within the experiment metrics vector.
For the Genetic Algorithm function we only refer to the position of the reporter that we want to use for evaluation.
The function uses the genalg package to set up a Genetic Algorithm function.
For details on the genalg function parameters see ?genalg::rbga
Finally, the function reports a simdesign object.

Genetic Algorithm simdesigns can only be executed using the \link[nlrx]{run_nl_dyn} function instead of \link[nlrx]{run_nl_all} or \link[nlrx]{run_nl_one}.
}
\examples{

# To attach a simdesign, a nl object needs to be created first (see ?nl).
# For this example, we load a nl object from test data.

nl <- nl_lhs
nl@simdesign <- simdesign_GenAlg(nl=nl,
                                  nseeds=1)



}
