% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{EV.rct}
\alias{EV.rct}
\title{Expected Values of the Cell Counts in RCT}
\usage{
EV.rct(rfct, nvec)
}
\arguments{
\item{rfct}{An RCT}

\item{nvec}{The \code{vector} of class sizes}
}
\value{
A \code{matrix} of the expected values of cell counts in the RCT.
}
\description{
Returns a \code{matrix} of same dimension as the RCT, \code{rfct}, 
whose entries are the expected cell counts of
the RCT under RL or CSR.

See also (\insertCite{ceyhan:NNreflexivity2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)
EV.rct(rfct,nvec)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
nvec<-as.numeric(table(fcls))
rfct<-rct(ipd,fcls)
EV.rct(rfct,nvec)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)

rfct<-rct(ipd,cls)
EV.rct(rfct,nvec)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rct}}, \code{\link{EV.nnct}} and \code{\link{EV.tct}}
}
\author{
Elvan Ceyhan
}
