% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{Tval}
\alias{Tval}
\title{\eqn{T} value in NN structure}
\usage{
Tval(W, R)
}
\arguments{
\item{W}{The incidence matrix, \eqn{W}, for the NN digraph}

\item{R}{The number of reflexive NNs (i.e., twice the number of reflexive NN pairs)}
}
\value{
Returns the \eqn{T} value. See the description above for the details of this quantity.
}
\description{
Returns the \eqn{T} value, which is the number of triplets \eqn{(z_i, z_j, z_k)} with 
"\eqn{NN(z_i) = NN(z_j) = z_k} and \eqn{NN(z_k) = z_j}" where \eqn{NN(\cdot)} is the nearest neighbor function.
Note that in the NN digraph, \eqn{T+R} is the sum of the indegrees of the points in the reflexive pairs.

This quantity (together with \eqn{Q} and \eqn{R}) is used in computing the variances and covariances of the entries of the
reflexivity contingency table. See (\insertCite{ceyhan:NNreflexivity2017;textual}{nnspat}) for further
details.
}
\examples{
#3D data points
n<-10
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
R<-Rval(W)
Tval(W,R)

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(5) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
R<-Rval(W)
Tval(W,R)

#with ties=TRUE in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
R<-Rval(W)
Tval(W,R)

}
\seealso{
\code{\link{Qval}}, \code{\link{Qvec}}, \code{\link{sharedNN}} and \code{\link{Rval}}
}
\author{
Elvan Ceyhan
}
