% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{docdb_create}
\alias{docdb_create}
\title{Create documents in a database}
\usage{
docdb_create(src, key, value, ...)
}
\arguments{
\item{src}{Source object, result of call to any of functions
\code{\link[=src_mongo]{src_mongo()}}, \code{\link[=src_sqlite]{src_sqlite()}}, \code{\link[=src_elastic]{src_elastic()}}, \code{\link[=src_couchdb]{src_couchdb()}}
\code{\link[=src_duckdb]{src_duckdb()}} or \code{\link[=src_postgres]{src_postgres()}}}

\item{key}{(character) The name of the container in the
database backend (corresponds to \code{collection} for MongoDB,
\code{dbname} for CouchDB, \code{index} for Elasticsearch, and to
a table name for DuckDB, SQLite and PostgreSQL)}

\item{value}{The data to be created in the database:
a single data.frame, a JSON string, a list, or a
file name or URL that points to NDJSON documents}

\item{...}{Passed to functions \code{\link[sofa:db_bulk_create]{sofa::db_bulk_create()}},
\code{\link[elastic:docs_bulk]{elastic::docs_bulk()}}, and \code{\link[mongolite:mongo]{mongolite::mongo()}}$insert()}
}
\value{
(integer) Number of successfully created documents
}
\description{
A message is emitted if the container \code{key} already exists.
}
\details{
An error is raised for document(s) in \code{value} when their
\verb{_id} already exist(s) in the collection \code{key};
use \code{\link[=docdb_update]{docdb_update()}} to update such document(s).
}
\section{Identifiers}{

If \code{value} is a data.frame that has a column \verb{_id},
or is a JSON string having a key \verb{_id} at root level,
or is a list having an item \verb{_id} at its top level,
this will be used as \verb{_id}'s and primary index
in the database. If there are no such \verb{_id}'s in \code{value},
row names (if any exist) of \code{value} will be used as \verb{_id}'s,
otherwise random \verb{_id}'s will be created (using
\code{\link[uuid:UUIDgenerate]{uuid::UUIDgenerate()}} with \code{use.time = TRUE} for
SQLite and PostgreSQL, or using DuckDB's built-in \code{uuid()}).
}

\examples{
\dontrun{
src <- src_sqlite()
docdb_create(src,
  key = "diamonds_small",
  value = as.data.frame(diamonds[1:3000L, ])
)
head(docdb_get(src, "diamonds_small"))
docdb_create(src, key = "contacts", value = contacts)
docdb_get(src, "contacts")[["friends"]]
}

}
