% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal.R
\name{ordinal}
\alias{ordinal}
\alias{nom_ord}
\title{Convert numbers to ordinal character vectors}
\usage{
ordinal(
  x,
  cardinal = TRUE,
  negative = getOption("nombre.negative", "negative")
)

nom_ord(
  x,
  cardinal = TRUE,
  negative = getOption("nombre.negative", "negative")
)
}
\arguments{
\item{x}{A numeric or character vector}

\item{cardinal}{Whether to convert a numeric vector to cardinal numbers
before applying ordinal suffixes.
When \code{TRUE}, 1 -> "first".
When \code{FALSE}, 1 -> "1st".
Defaults to \code{TRUE}.}

\item{negative}{A character of length one to append to negative numbers.
Defaults to \code{"negative"}.
Default can be changed by setting \code{options("nombre.negative")}.}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Adds ordinal suffixes to numbers (or a character vector of number-like
words).
Converts numeric vectors to cardinal numbers before adding prefixes unless
\code{cardinal} is \code{FALSE}.
}
\examples{
nom_ord(2)
nom_ord(1:10)
nom_ord(525600)

nom_ord(1:10, cardinal = FALSE)

nom_ord(c("n", "dozen", "umpteen", "eleventy", "one zillion"))
}
