% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite_sf.R
\name{reverse_geo_lite_sf}
\alias{reverse_geo_lite_sf}
\title{Reverse geocoding API for OSM elements in \CRANpkg{sf} format}
\usage{
reverse_geo_lite_sf(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  progressbar = TRUE,
  custom_query = list(),
  points_only = TRUE
)
}
\arguments{
\item{lat}{Latitude values in numeric format. Must be in the range
\eqn{\left[-90, 90 \right]}.}

\item{long}{Longitude values in numeric format. Must be in the range
\eqn{\left[-180, 180 \right]}.}

\item{address}{Address column name in the output data (default  \code{"address"}).}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_coords}{Return input coordinates with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See \strong{Details}.}

\item{points_only}{Logical \code{TRUE/FALSE}. Whether to return only spatial
points (\code{TRUE}, which is the default) or potentially other shapes as
provided by the Nominatim API (\code{FALSE}). See \strong{About Geometry Types}.}
}
\value{
A \code{\link[sf:sf]{sf}} object with the results.
}
\description{
Generates an address from a latitude and longitude. Latitudes must be
between \eqn{\left[-90, 90 \right]} and longitudes between
\eqn{\left[-180, 180 \right]}. This function returns the spatial object
associated with the query using \CRANpkg{sf}, see \code{\link[=reverse_geo_lite]{reverse_geo_lite()}} for
retrieving the data in \code{\link[tibble:tibble]{tibble}} format.
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Zooming}{


Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{ll}{
   \strong{zoom} \tab \strong{address_detail} \cr
   \code{3} \tab country \cr
   \code{5} \tab state \cr
   \code{8} \tab county \cr
   \code{10} \tab city \cr
   \code{14} \tab suburb \cr
   \code{16} \tab major streets \cr
   \code{17} \tab major and minor streets \cr
   \code{18} \tab building \cr
}
}

\section{About Geometry Types}{


The parameter \code{points_only} specifies whether the function results will be
points (all Nominatim results are guaranteed to have at least point
geometry) or possibly other spatial objects.

Note that the type of geometry returned in case of \code{points_only = FALSE}
will depend on the object being geocoded:
\itemize{
\item Administrative areas, major buildings and the like will be
returned as polygons.
\item Rivers, roads and their like as lines.
\item Amenities may be points even in case of a \code{points_only = FALSE} call.
}

The function is vectorized, allowing for multiple addresses to be geocoded;
in case of \code{points_only = FALSE}  multiple geometry types may be returned.
}

\examples{
\dontshow{if (nominatim_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(ggplot2)

# Coliseum coords
col_lon <- 12.49309
col_lat <- 41.89026

# Coliseum as polygon
col_sf <- reverse_geo_lite_sf(
  lat = col_lat,
  lon = col_lon,
  points_only = FALSE
)

dplyr::glimpse(col_sf)

if (any(!sf::st_is_empty(col_sf))) {
  ggplot(col_sf) +
    geom_sf()
}

# City of Rome - same coords with zoom 10

rome_sf <- reverse_geo_lite_sf(
  lat = col_lat,
  lon = col_lon,
  custom_query = list(zoom = 10),
  points_only = FALSE
)

dplyr::glimpse(rome_sf)

if (any(!sf::st_is_empty(rome_sf))) {
  ggplot(rome_sf) +
    geom_sf()
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reverse_geo_lite]{reverse_geo_lite()}}.

Reverse geocoding coordinates: 
\code{\link{reverse_geo_lite}()}

Get \code{\link[sf:sf]{sf}} objects: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_address_lookup_sf}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_lite_sf}()},
\code{\link{geo_lite_struct_sf}()}
}
\concept{reverse}
\concept{spatial}
