% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DFA.R
\name{dfa}
\alias{dfa}
\alias{estimate.dfa}
\alias{fluctuationFunction.dfa}
\alias{plot.dfa}
\alias{windowSizes.dfa}
\title{Detrended Fluctuation Analysis}
\usage{
dfa(time.series, window.size.range = c(10, 300), npoints = 20,
  do.plot = TRUE, ...)

\method{windowSizes}{dfa}(x)

\method{fluctuationFunction}{dfa}(x)

\method{plot}{dfa}(x, main = "Detrended fluctuation analysis\\n",
  xlab = "Window size: t", ylab = "Fluctuation function: F(t)",
  log = "xy", ...)

\method{estimate}{dfa}(x, regression.range = NULL, do.plot = FALSE,
  fit.col = 2, fit.lty = 1, fit.lwd = 1, add.legend = T, ...)
}
\arguments{
\item{time.series}{The original time series to be analyzed.}

\item{window.size.range}{Range of values for the windows size that will be used
to estimate the fluctuation function. Default: c(10,300).}

\item{npoints}{The number of different window sizes that will be used to estimate
the Fluctuation function in each zone.}

\item{do.plot}{logical value. If TRUE (default value), a plot of the Fluctuation function is shown.}

\item{...}{Additional graphical parameters.}

\item{x}{A \emph{dfa} object.}

\item{main}{A title for the plot.}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{log}{A character string which contains "x" if the x axis is to be
logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if
both axes are to be logarithmic.}

\item{regression.range}{Vector with 2 components denoting the range where the function will perform linear regression.}

\item{fit.col}{A colors to plot the regression line.}

\item{fit.lty}{The type of line to plot the regression line.}

\item{fit.lwd}{The width of the line for the regression line.}

\item{add.legend}{add a legend with the resulting estmation to the plot?}
}
\value{
A \emph{dfa}  object.

The \emph{windowSizes} function returns the windows sizes used
to detrend the time series.

The \emph{fluctuationFunction} function returns the fluctuation function
obtained in the DFA represented by the \emph{dfa} object.
}
\description{
Functions for performing Detrended Fluctuation Analysis (DFA), a widely used
technique for detecting long range correlations in time series. These functions
are able to estimate several scaling exponents from the time series being analyzed.
These scaling exponents  characterize short or long-term fluctuations, depending of
the range used for regression (see  details).
}
\details{
The Detrended Fluctuation Analysis (DFA) has become a widely used
technique for detecting long range correlations in time series. The DFA procedure
may be summarized as follows:
\enumerate{
 \item Integrate the time series to be analyzed. The time series resulting from the
 integration will be referred to as the profile.
 \item Divide the profile into N non-overlapping segments.
 \item  Calculate the local trend for each of the segments using least-square regression.
 Compute the total error for each ofi the segments.
 \item Compute the average of the total error over all segments and take its root square. By repeating
 the previous steps for several segment sizes (let's denote it by t), we obtain the
 so-called Fluctuation function \eqn{F(t)}.
 \item  If the data presents long-range power law correlations:  \eqn{F(t) \sim t^\alpha}{F(t) proportional t^alpha} and
 we may estimate using regression.
 \item  Usually, when plotting \eqn{\log(F(t))\;Vs\;log(t)}{log(F(t)) Vs log(t)} we may distinguish two linear regions.
 By regression them separately, we obtain two scaling exponents, \emph{\eqn{\alpha_1}{alpha1}}
 (characterizing short-term fluctuations) and \emph{\eqn{\alpha_2}{alpha2}} (characterizing long-term fluctuations).
}
Steps 1-4 are performed using the \emph{dfa} function. In order to obtain a estimate
of some scaling exponent, the user must use the  \emph{estimate} function specifying
the regression range (window sizes used to detrend the series).
}
\examples{
\dontrun{
 white.noise = rnorm(5000)
dfa.analysis = dfa(time.series = white.noise, npoints = 10,
                 window.size.range=c(10,1000), do.plot=FALSE)
white.estimation = estimate(dfa.analysis,do.plot=TRUE)
cat("Theorical: 0.5---Estimated: ",white.estimation ,"\\n")


library(fArma)
fgn = as.numeric(fArma::fgnSim(n = 2000, H = 0.75))
dfa.analysis = dfa(time.series = fgn, npoints = 30,
                   window.size.range=c(10,1000),
                   do.plot=FALSE)
fgn.estimation = estimate(dfa.analysis, do.plot = TRUE,
                          fit.col="blue",fit.lwd=2,fit.lty=2,
                          main="Fitting DFA to fGn")
cat("Theorical: 0.75---Estimated: ",fgn.estimation ,"\\n")


fbm = as.numeric(fArma::fbmSim(n = 2000, H = 0.25))
dfa.analysis = dfa(time.series = fbm, npoints = 50,
                   window.size.range=c(10,300),
                   do.plot=FALSE)
fbm.estimation = estimate(dfa.analysis,do.plot = TRUE,
                          add.legend=F, main="DFA of fBm")
cat("Theorical: 1.25 ---Estimated: ",fbm.estimation ,"\\n")

}
}
\author{
Constantino A. Garcia
}

