% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLik.not}
\alias{logLik.not}
\title{Extract likelihood from a 'not' object}
\usage{
\method{logLik}{not}(object, cpt, ...)
}
\arguments{
\item{object}{An object of class 'not', returned by \code{\link{not}}.}

\item{cpt}{An integer vector with locations of the change-points.
If missing, the \code{\link{features}} is called internally to extract the change-points from \code{object}.}

\item{...}{Further parameters that can be passed to \code{\link{predict.not}} and \code{\link{features}}.}
}
\description{
Calculates the Gaussian log-likelihood for the signal estimated using \code{\link{predict.not}} with the change-points at \code{cpt}. The type of the signal depends on 
on the value of \code{contrast} that has been passed to \code{\link{not}} (see \code{\link{predict.not}}).
}
\examples{
#' # **** Piecewisce-constant mean with Gaussian noise.
x <- c(rep(0, 100), rep(1,100)) + rnorm(100)
# *** identify potential locations of the change-points
w <- not(x, contrast = "pcwsConstMean")
# *** log-likelihood for the model with the change-point estimated  via 'not'
logLik(w)
# *** log-likelihood for the model with the change-point at 100
logLik(w, cpt=100)
}
