% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nowcast.R
\name{nowcast}
\alias{nowcast}
\title{Nowcasting of a quarterly time serie using a dynamic factor.}
\usage{
nowcast(y, regressors, q = 2, r = 2, p = 1)
}
\arguments{
\item{y}{Stationary quarterly time-series}

\item{regressors}{A time series matrix (\code{mts}) representing the regressors of interest. The series must be stationary.}

\item{q}{Dynamic rank. Number of error terms. If not specified q = 2.}

\item{r}{Static rank (r>=q), i.e. number of factors. If not specified r = 2.}

\item{p}{AR order of factors. If not specified p = 1.}
}
\value{
A \code{list} containing two elements:

A \code{data.frame} named \code{main} contains the original serie, the estimation in the sample, the estimation out of the sample;

A \code{list} named \code{factors} contains the estimated factors and coeffients..
}
\description{
Estimate nowcasting and foreacasting for a quarterly time serie. The method is based on 
\emph{Giannone et al. 2008}
}
\examples{
pib<-base_extraction(22099)
now<-nowcast(lag(pib,-2),Bpanel(vintage,rep(3,dim(vintage)[2])))
now$prev
now$factors
}
\references{
Giannone, D., Reichlin, L., & Small, D. (2008). Nowcasting: The real-time informational content of macroeconomic data. Journal of Monetary Economics, 55(4), 665-676.<doi:10.1016/j.jmoneco.2008.05.010>
}
\seealso{
\code{\link[nowcasting]{base_extraction}}
}
