% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_t4.R
\name{replext_t4_c3.1}
\alias{replext_t4_c3.1}
\title{Replicate and Extend Simulation Results from Table 4 Cell 3.1}
\usage{
replext_t4_c3.1(
  rdist = "rchisq",
  par1_1 = 3,
  par2_1 = 0,
  par1_2 = 6,
  par2_2 = 0,
  n1 = c(5, 5, 10),
  n2 = c(5, 10, 10),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{rdist}{Distribution type, with the default set to 'rchisq' (Chi-squared).
Other options include 'rlnorm' (lognormal), 'rpois' (Poisson), and
'rcauchy' (Cauchy).}

\item{par1_1}{First parameter for the first group's distribution,
default is 3 for Chi-squared's degrees of freedom (df).}

\item{par2_1}{Second parameter for the first group's distribution,
typically 0 for Chi-squared.}

\item{par1_2}{First parameter for the second group's distribution,
default is 6 for Chi-squared's degrees of freedom (df).}

\item{par2_2}{Second parameter for the second group's distribution,
typically 0 for Chi-squared.}

\item{n1}{Vector of sample sizes for the first group.}

\item{n2}{Vector of sample sizes for the second group, must be the same
length as n1.}

\item{n_simulations}{Number of simulations to run, default is 10,000.}

\item{nboot}{Number of bootstrap samples, default is 1000.}

\item{conf.level}{Confidence level for calculating p-value thresholds,
default is 0.95.}
}
\value{
A data frame with columns for each sample size pair (n1, n2) and
the proportions of significant p-values for each test (ST, WT, NPBTT,
WRST, PTTa, PTTe).
}
\description{
This function is a specialized wrapper around 'replext_t4_c1.1' intended
to replicate and extend the simulation results from Table 4 cell 3.1 of
the paper by Dwivedi et al. (2017). The default parameters are configured
to match the Chi-squared distribution scenarios as detailed in the paper.
Adjusting these parameters allows users to extend these results further.
}
\note{
When using rlnorm (lognormal distribution), 'par1' represents 'meanlog'
(the mean of the logarithms) and 'par2' represents 'sdlog' (the standard
deviation of the logarithms). For rpois (Poisson distribution), 'par1' is
'lambda' (the rate parameter). In the case of rchisq (Chi-squared distribution),
'par1' is 'df' (degrees of freedom) and 'par2' is 'ncp'
(non-centrality parameter). Lastly, for rcauchy (Cauchy distribution),
'par1' is the 'location' parameter and 'par2' is the 'scale' parameter.
}
\examples{
replext_t4_c3.1(n1 = c(10), n2 = c(10),n_simulations = 1)

}
\references{
Dwivedi AK, Mallawaarachchi I, Alvarado LA. Analysis of small sample size
studies using nonparametric bootstrap test with pooled resampling method.
Stat Med. 2017 Jun 30;36(14):2187-2205. doi: 10.1002/sim.7263. Epub 2017 Mar 9. PMID: 28276584.
}
