% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNpde-distributionPlot.R
\name{npde.plot.dist}
\alias{npde.plot.dist}
\alias{aux.npdeplot.hist}
\alias{aux.npdeplot.dist}
\title{Distribution plots of pd/npde}
\usage{
npde.plot.dist(npdeObject, which="npd", dist.type="qqplot", ...)
}
\arguments{
\item{npdeObject}{an object returned by a call to \code{\link{npde}} or \code{\link{autonpde}}}

\item{which}{a string determining which metric to plot (one of "npde", "pd" or "npd"), defaults to "npd"}

\item{dist.type}{string, one of "ecdf" (empirical cumulative density function), "hist" (histogram) or "qqplot" (QQ-plot of the empirical distribution versus the theoretical quantiles) to determine which type of plot (default is "qqplot")}

\item{\dots}{additional arguments to be passed on to the function, to control which metric (npde, pd, npd) is used or to override graphical parameters (see the PDF document for details, as well as \code{\link{set.plotoptions}})}
}
\value{
a ggplot object or a list of ggplot objects (grobs)
}
\description{
Produces a plot of the cdistribution of a metric compared to their theoretical distribution. Three types of distribution plots are available:
a histogram, a QQ-plot, or the empirical cdf.
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F.  Mentre.
Metrics for external model evaluation with an application to the population pharmacokinetics of gliclazide.
\emph{Pharmaceutical Research}, 23:2036--49, 2006.
}
\seealso{
\code{\link{npde}}, \code{\link{autonpde}}, \code{\link{set.plotoptions}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@bichat.inserm.fr>
}
\keyword{plot}
