% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alleleFreq.R
\name{alleleFreq}
\alias{alleleFreq}
\title{Calculates the count of each allele in the provided vector.}
\usage{
alleleFreq(alleles, ids = NULL)
}
\arguments{
\item{alleles}{an integer vector of alleles in the population}

\item{ids}{character vector of IDs indicating to which animal each allele
in \code{alleles} belongs.}
}
\value{
A data.frame with columns \code{allele} and \code{freq}. This is a
 table of allele counts within the population.
}
\description{
Part of Genetic Value Analysis
}
\details{
If ids are provided, the function will only count the unique alleles
for an individual (homozygous alleles will be counted as 1).
}
\examples{
\donttest{
library(nprcgenekeepr)
data("ped1Alleles")
ids <- ped1Alleles$id
alleles <- ped1Alleles[, !(names(ped1Alleles) \%in\% c("id", "parent"))]
aF <- alleleFreq(alleles[[1]], ids = NULL)
aF[aF$freq >= 10, ]
}

}
