% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctParentSex.R
\name{correctParentSex}
\alias{correctParentSex}
\title{Sets sex for animals listed as either a sire or dam.}
\usage{
correctParentSex(id, sire, dam, sex, recordStatus, reportErrors = FALSE)
}
\arguments{
\item{id}{character vector with unique identifier for an individual}

\item{sire}{character vector with unique identifier for an
individual's father (\code{NA} if unknown).}

\item{dam}{character vector with unique identifier for an
individual's mother (\code{NA} if unknown).}

\item{sex}{factor with levels: "M", "F", "U". Sex specifier for an
individual.}

\item{recordStatus}{character vector with value of \code{"added"} or
\code{"original"}, which indicates whether an animal was added or an
original animal.}

\item{reportErrors}{logical value if TRUE will scan the entire file and
make a list of all errors found. The errors will be returned in a
list of list where each sublist is a type of error found.}
}
\value{
A factor with levels: "M", "F", "H", and "U"
representing the sex codes for the ids provided
}
\description{
Part of Pedigree Curation
}
\examples{
\donttest{
library(nprcgenekeepr)
pedOne <- data.frame(id = c("s1", "d1", "s2", "d2", "o1", "o2", "o3", "o4"),
                     sire = c(NA, "s0", "s4", NA, "s1", "s1", "s2", "s2"),
                     dam = c(NA, "d0", "d4", NA, "d1", "d2", "d2", "d2"),
                     sex = c("F", "F", "M", "F", "F", "F", "F", "M"),
                     recordStatus = rep("original", 8),
                     stringsAsFactors = FALSE)
pedTwo <- data.frame(id = c("s1", "d1", "s2", "d2", "o1", "o2", "o3", "o4"),
                     sire = c(NA, "s0", "s4", NA, "s1", "s1", "s2", "s2"),
                     dam = c("d0", "d0", "d4", NA, "d1", "d2", "d2", "d2"),
                     sex = c("M", "M", "M", "F", "F", "F", "F", "M"),
                     recordStatus = rep("original", 8),
                     stringsAsFactors = FALSE)
pedOneCorrected <- pedOne
pedOneCorrected$sex <- correctParentSex(pedOne$id, pedOne$sire, pedOne$dam,
                                        pedOne$sex, pedOne$recordStatus)
pedOne[pedOne$sex != pedOneCorrected$sex, ]
pedOneCorrected[pedOne$sex != pedOneCorrected$sex, ]

pedTwoCorrected <- pedTwo
pedTwoCorrected$sex <- correctParentSex(pedTwo$id, pedTwo$sire, pedTwo$dam,
                                        pedTwo$sex, pedOne$recordStatus)
pedTwo[pedTwo$sex != pedTwoCorrected$sex, ]
pedTwoCorrected[pedTwo$sex != pedTwoCorrected$sex, ]
}

}
