% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProductionStatus.R
\name{getProductionStatus}
\alias{getProductionStatus}
\title{Get production status of group}
\usage{
getProductionStatus(
  ped,
  minParentAge = 3,
  maxOffspringAge = NULL,
  housing = "shelter_pens",
  currentDate = Sys.Date()
)
}
\arguments{
\item{ped}{Dataframe that is the `Pedigree`. It contains pedigree
information. The \code{id}, \code{dam}, \code{sex} and \code{age}
(in years) columns are required.}

\item{minParentAge}{Numeric values to set the minimum age in years for
an animal to have an offspring. Defaults to 2 years. The check is not
performed for animals with missing birth dates.}

\item{maxOffspringAge}{Numeric values to set the maximum age in years for
an animal to be counted as birth in calculation of production status
ratio.}

\item{housing}{character vector of length 1 having the housing type, which
is either \emph{"shelter_pens"} or \emph{"corral"}.}

\item{currentDate}{Date to be used for calculating age. Defaults to
\code{Sys.Date()}.}
}
\value{
\code{production} -- Ratio of the number of births that live >30
days to the number of females >= 3 years of age.
}
\description{
Get production status of group
}
\details{
Description of how Production and Production Status (color) is
calculated.
\enumerate{
\item  The Production Status is calculated on September 09, 2019,
       Births = count of all animals in group born since January 1,
       2017 through December 31, 2018, that lived at least 30 days.
\item  Dams = count of all females in group that have a birth date on or
       prior to September 09, 2016.
\item  Production = Births / Dams
\item  Production Status (color)
    \enumerate{
    \item  Shelter and pens
        \enumerate{
        \item   Production < 0.6; Red
        \item   Production >= 0.6 and Production <= 0.63; Yellow
        \item   Production > 0.63; Green
    }
    \item  Corrals
        \enumerate{
        \item   Production < 0.5; Red
        \item   Production >= 0.5 and Production <= 0.53; Yellow
        \item   Production > 0.53; Green
        }
    }
 }

This code may need to be modified to allow the user to supply a list
of IDs to include as group members. Currently each animal in the
provided pedigree (\code{ped}) is considered to be a member of the
group.
}
