% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_valid_date_str.R
\name{is_valid_date_str}
\alias{is_valid_date_str}
\title{Returns TRUE if the string is a valid date.}
\usage{
is_valid_date_str(
  date_str,
  format = "\%d-\%m-\%Y \%H:\%M:\%S",
  optional = FALSE
)
}
\arguments{
\item{date_str}{character vector with 0 or more dates}

\item{format}{character vector of length one having the date format}

\item{optional}{parameter to \code{as.Date}. Logical value indicating
to return NA (instead of signaling an error) if the format guessing does not
succeed. Defaults to FALSE.}
}
\value{
A logical value or \code{NA} indicating whether or not the provided
character vector represented a valid date string.
}
\description{
Taken from github.com/rmsharp/rmsutilityr
}
\examples{
is_valid_date_str(c(
  "13-21-1995", "20-13-98", "5-28-1014",
  "1-21-15", "2-13-2098", "25-28-2014"
), format = "\%m-\%d-\%y")
}
