% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-stock.R
\name{nse_stock_top_base}
\alias{nse_stock_top_base}
\alias{nse_stock_top_gainers}
\alias{nse_stock_top_losers}
\title{NSE top gainers & losers}
\usage{
nse_stock_top_gainers(clean_names = TRUE)

nse_stock_top_losers(clean_names = TRUE)
}
\arguments{
\item{clean_names}{Logical; if \code{TRUE}, makes the column names
descriptive and uses snake_case.}
}
\value{
A tibble with the following columns:

\item{symbol}{NSE ticker.}
\item{series}{Equity (EQ).}
\item{last_corp_announcement_date}{Last corporate announcement date.}
\item{last_corp_announcement}{Last corporate announcement.}
\item{open_price}{Open price.}
\item{high_price}{High price.}
\item{low_price}{Low price.}
\item{last_traded_price}{Last traded price.}
\item{prev_close_price}{Previous close price.}
\item{percent_change}{Percentage change in price.}
\item{traded_quantity}{Total traded quantity.}
\item{turnover}{Turnover in lakhs.}
}
\description{
Fetch top gainers and losers for the last trading session.
}
\examples{
\donttest{
# top gainers
nse_stock_top_gainers()

# retain original column names as returned by NSE
nse_stock_top_gainers(clean_names = FALSE)

# top losers
nse_stock_top_losers()

# retain original column names as returned by NSE
nse_stock_top_losers(clean_names = FALSE)
}

}
