% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quo}
\alias{quo}
\alias{quotation}
\alias{quo_}
\alias{env}
\alias{env.quotation}
\alias{env<-}
\alias{env<-.quotation}
\alias{expr}
\alias{expr.quotation}
\alias{expr<-}
\alias{expr<-.quotation}
\alias{is.quotation}
\alias{as.quo}
\alias{as.quo.function}
\alias{as.quo.quotation}
\alias{as.quo.dots}
\alias{as.quo.formula}
\alias{as.quo.lazy}
\alias{as.quo.default}
\title{Quotation objects.}
\usage{
quo(expr, env = arg_env_(quote(expr), environment()), force = FALSE)

quo_(expr, env, force = FALSE)

env(q)

\method{env}{quotation}(q)

env(q) <- value

\method{env}{quotation}(q) <- value

expr(q)

\method{expr}{quotation}(q)

expr(q) <- value

\method{expr}{quotation}(q) <- value

is.quotation(x)

as.quo(x)

\method{as.quo}{function}(x)

\method{as.quo}{quotation}(x)

\method{as.quo}{dots}(x)

\method{as.quo}{formula}(x)

\method{as.quo}{lazy}(x)

\method{as.quo}{default}(x)
}
\arguments{
\item{expr}{An expression. For \code{quo} this is taken literally and
not evaluated. For \code{quo_} this is evaluated normally.}

\item{env}{An \link{environment}.}

\item{force}{Immediately evaluate the expression and create a
\link{forced} quotation, i.e. one that stores an expression and value,
but no environment.}

\item{q}{A quotation object.}

\item{value}{An updated value.}

\item{x}{Any object.}
}
\value{
\code{quo_} and \code{quo} return an object of class "quotation".

\code{as.quo} returns a quotation.
}
\description{
\code{quo} captures its argument literally, that is, without evaluating,
and constructs a quotation. A quotation has two parts: an
expression \code{expr(q)} with an environment \code{env(q)}. (Like in
writing, an 'expression' may simply be a set of words, but a
'quotation' comes bundled with a citation, to reference a context
in which it was said.)

\code{quo_(expr, env)} is the normally evaluating version. It
constructs a quotation given an expression and environment.

\code{as.quo(x)} converts an object into a quotation. Closures,
formulas, and single-element \link{dots} can be converted this way.
}
\details{
A quo is parallel to a 'promise' which is the data structure R uses
to hold lazily evaluated arguments. A quo is different from a
promise because it is an immutable data object.

As a data object, a quo does not automatically evaluate like a
promise, but can be evaluated explicitly with the methods \link{value}
or \link{force_}.  A quo is immutable, so it does not mutate into a
"forced" state if you choose to evaluate it.

A function can capture its arguments as quotations using \code{\link{arg}}.

A \link{dots} object is a list of quotations.
}
