% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{data_filtering}
\alias{data_filtering}
\title{Filters the data above the thresholds (set to zero).
Thresholds can be a single value, or equal to the number of rows.
If \code{thresholds} is set to \code{NA}, no thresholding happens.}
\usage{
data_filtering(data, thresholds = NA)
}
\arguments{
\item{data}{Data to filter. Can be vector or matrix.}

\item{thresholds}{Filtering thresholds. Defaults to \code{NA} but can be
a mixture of \code{NA}s and numerical values
(with length equal to \code{nrow(data)}).}
}
\value{
List of filtered data vector or matrix (\verb{$data})
and binary matrix of filtered times (\code{filter}) (\code{TRUE} means filtered).
}
\description{
Filters the data above the thresholds (set to zero).
Thresholds can be a single value, or equal to the number of rows.
If \code{thresholds} is set to \code{NA}, no thresholding happens.
}
\examples{
n <- 10000
d <- 5
data <- matrix(rnorm(n * d), ncol = d)

# No filtering
data_filtering(data)

# Filtering everything
data_filtering(data, 0.0)
data_filtering(data, rep(0.0, d))

# Filtering only the first col
data_filtering(data, c(0.0, rep(NA, d - 1)))
}
