% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levy_recovery.R
\name{levy_recovery}
\alias{levy_recovery}
\title{Apply the Levy recovery on data with (fitted) adjacency/dynamics matrix.}
\usage{
levy_recovery(adj, data, times, look_ahead = 1)
}
\arguments{
\item{adj}{Adjacency or dynamics matrix.}

\item{data}{Data to apply the Levy recovery (vector).}

\item{times}{Observation times (vector).}

\item{look_ahead}{Step increment.}
}
\value{
List with recovered increments, adjacency matrix and cumulative sum.
}
\description{
Apply the Levy recovery on data with (fitted) adjacency/dynamics matrix.
}
\examples{
n <- 1000
d <- 2
times <- seq(n)
delta_time <- 0.01
noise <- cbind(ghyp::rghyp(n, ghyp::ghyp()), ghyp::rghyp(n, ghyp::ghyp()))
data <- construct_path(
  diag(d),
  noise = noise, y_init = rep(0, d), delta_time = delta_time
)
levy_recovery(adj = diag(d), data = data, times = times)
}
