% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorsinclasses.R
\name{colors.in.classes.folder}
\alias{colors.in.classes.folder}
\title{Compute colors in classes distribution for folders}
\usage{
colors.in.classes.folder(path, color1, color2 = NULL, N = 7,
  type = "intensity", thresh1 = NULL, thresh2 = NULL, sd1 = 2,
  sd2 = 2, col1 = "green", col2 = "red", cores = 1)
}
\arguments{
\item{path}{Path to root folder}

\item{color1}{Image of first color}

\item{color2}{Image of second color}

\item{N}{Maximum number of classes}

\item{type}{Type of spot definition, see details}

\item{thresh1}{Threshold for first color image}

\item{thresh2}{Threshold for second color image}

\item{sd1}{For automatic threshold, that is: mean(color1)+sd1*sd(color1)}

\item{sd2}{For automatic threshold of color2}

\item{col1}{Name of color 1}

\item{col2}{Name of color 2}

\item{cores}{Number of cores used in parallel, cores=1 implies no parallelization}
}
\value{
Results are in folder colorsinclasses
}
\description{
Compute colors in classes distribution for folders
}

