% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\docType{package}
\name{nzilbb.labbcat}
\alias{nzilbb.labbcat}
\alias{nzilbb.labbcat-package}
\title{\packageTitle{nzilbb.labbcat}}
\description{
\packageDescription{nzilbb.labbcat}
}
\details{
\packageDESCRIPTION{nzilbb.labbcat}
\packageIndices{nzilbb.labbcat}

'LaBB-CAT' is a web-based language corpus management system and this
package provides access to data stored in a 'LaBB-CAT' instance.
You must have at least version 20190412.1154 of 'LaBB-CAT' to use
this package.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## optionally specify the username/password in the script
## (if this is not done, we will be prompted for the username/password)
labbcatCredentials(labbcat.url, "demo", "demo")

## Get the 5 seconds starting from 10s as a mono 22kHz file
wav.file <- getSoundFragment(labbcat.url, "AP2505_Nelson.eaf", 10.0, 15.0, 22050)
}

}
\references{
\cite{Robert Fromont and Jennifer Hay, "{ONZE Miner}: the development of a browser-based research tool", 2008}
\cite{Robert Fromont, "Toward a format-neutral annotation store", 2017}
}
\author{
\packageAuthor{nzilbb.labbcat}
}
\keyword{package}
