% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_col_dt_format}
\alias{df_col_dt_format}
\title{Replace unix timestamp column(s) to formated dt string}
\usage{
df_col_dt_format(
  df,
  col,
  dt_format = "\%Y-\%m-\%d \%H:\%M:\%S",
  on_missing_col = "warn"
)
}
\arguments{
\item{df}{data.frame, input data.frame}

\item{col}{character vector, column names of the df that will be modified}

\item{dt_format}{string, date time format}

\item{on_missing_col}{string, behavior for missing column(s):
"warn" - log warning, "skip" - skip missing column(s), "stop" - throw error}
}
\value{
Modified input data.frame
}
\description{
Replace unix timestamp column(s) to formated dt string
}
\examples{
df <- data.frame(
  x = c("a", "b"),
  dt = c(1687868601, 1688417643)
)
df_col_dt_format(df, "dt")
df_col_dt_format(df, "dt", "\%H:\%M")

}
