% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_images.R
\name{images_edit_request}
\alias{images_edit_request}
\title{API images: edit request}
\usage{
images_edit_request(
  api_key,
  image,
  prompt,
  mask = NULL,
  response_format = NULL,
  size = NULL,
  n = NULL,
  user = NULL
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see \url{https://platform.openai.com/account/api-keys})}

\item{image}{string/raw, the image to edit. Must be a valid PNG file, less
than 4MB, and square. If mask is not provided, image must have transparency,
which will be used as the mask.}

\item{prompt}{string, a text description of the desired image(s).
The maximum length is 1000 characters.}

\item{mask}{string/raw/null, an additional image whose fully transparent
areas (e.g. where alpha is zero) indicate where image should be edited. Must
be a valid PNG file, less than 4MB, and have the same dimensions as `image`.}

\item{response_format}{string, the format in which the generated images
are returned. Must be one of "url" or "b64_json".}

\item{size}{string, the size of the generated images. Must be one of
"256x256", "512x512" or "1024x1024"}

\item{n}{integer, the number of images to generate. Must be between 1 and 10.}

\item{user}{string a unique identifier representing your end-user,
which can help OpenAI to monitor and detect abuse.}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
\url{https://platform.openai.com/docs/api-reference/images/edits}
}
