% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_chat.R
\name{chat_request}
\alias{chat_request}
\title{API chat: send create (chat) request}
\usage{
chat_request(
  api_key,
  messages,
  model = "gpt-3.5-turbo",
  temperature = 0.7,
  n = 1,
  max_tokens = 50,
  presence_penalty = 0,
  frequency_penalty = 0
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{messages}{data.frame, data.frame with messages comprising the conversation so far}

\item{model}{string, ID of the model to use.
See the model endpoint compatibility table (https://platform.openai.com/docs/models/model-endpoint-compatibility)
for details on which models work with the Chat API.}

\item{temperature}{double, what sampling temperature to use, between 0 and 2.
Higher values like 0.8 will make the output more random,
while lower values like 0.2 will make it more focused and deterministic.}

\item{n}{integer, how many chat completion choices
to generate for each input message.}

\item{max_tokens}{integer, the maximum number of tokens to generate
in the chat completion}

\item{presence_penalty}{double, number between -2.0 and 2.0.
Positive values penalize new tokens based on whether they appear in the text
so far, increasing the model's likelihood to talk about new topics.}

\item{frequency_penalty}{double, number between -2.0 and 2.0.
Positive values penalize new tokens based on their existing frequency
in the text so far, decreasing the model's likelihood to repeat the same line
verbatim.}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
To get more details, visit https://platform.openai.com/docs/api-reference/chat/create
}
\examples{
\dontrun{
  question <- dialog_df("hi")
  res_content <- chat_request(
    api_key = "my-secret-api-key-string",
    messages = question
  )
  if (!is_error(res_content)) {
    answer <- chat_fetch_messages(res_content)
    conversation <- merge_dialog_df(question, answer)
    print(conversation)
  }
}

}
