% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_fine-tuning.R
\name{fine_tuning_events_list_request}
\alias{fine_tuning_events_list_request}
\title{API fine-tuning: list events request}
\usage{
fine_tuning_events_list_request(
  api_key,
  fine_tuning_job_id,
  after = NULL,
  limit = NULL
)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{fine_tuning_job_id}{string, the ID of the fine-tuning job to get events for}

\item{after}{string/NULL, identifier for the last event from the previous pagination request.}

\item{limit}{integer/NULL, number of events to retrieve (defaults to 20)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Get status updates for a fine-tuning job. To get more details, visit
https://platform.openai.com/docs/guides/fine-tuning
https://platform.openai.com/docs/api-reference/fine-tuning/list-events
}
\examples{
\dontrun{
res_content <- fine_tuning_events_list_request("my-secret-api-key-string", "job-id")
if (!is_error(res_content)) {
  fine_tuning_events_df <- fine_tuning_fetch_events_list(res_content)
  print(fine_tuning_events_df)
}
}

}
