% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaves.R
\name{leaves}
\alias{leaves}
\alias{leaves.rtree}
\alias{is_leafnode}
\title{Leaves of a tree}
\usage{
leaves(.tree)

\method{leaves}{rtree}(.tree)

is_leafnode(.node, .tree)
}
\arguments{
\item{.tree}{A tree.}

\item{.node}{A node of \code{.tree}.}
}
\value{
A (possibly empty) list of nodes.
}
\description{
The function \code{leaves} returns the leaves  
of a tree.
}
\examples{
## Chains
(tr0 = c_("Bob", "Carl", "Daniel"))
leaves(tr0)
(tr1 = c_("Bill", "Caroline", "Dimitri", "Enoc"))
leaves(tr1)

## Rooted tree
(tr2 = r_("Alice", s = list(tr0, tr1)))
leaves(tr2)

## Unrooted tree
(tr3 = r_(s = list(tr2, c_("Grand-Mother", "Father", "Son"))))
leaves(tr3)

}
